import { Video, Mail, Phone, MapPin, Instagram, Youtube, Twitter } from 'lucide-react'
import './Footer.css'

const Footer = () => {
  return (
    <footer className="footer-tech">
      <div className="container">
        <div className="footer-content-tech">
          <div className="footer-section-tech">
            <div className="footer-logo-tech">
              <div className="footer-logo-icon">
                <Video size={24} strokeWidth={2.5} />
              </div>
              <h2 className="footer-logo-text-tech">EditPro</h2>
            </div>
            <p className="footer-description-tech">
              Профессиональные курсы видеомонтажа для начинающих и продвинутых. 
              Изучите все тонкости работы с видео от опытных преподавателей.
            </p>
            <div className="footer-social-tech">
              <a href="#" className="social-link-tech">
                <Instagram size={20} strokeWidth={2} />
              </a>
              <a href="#" className="social-link-tech">
                <Youtube size={20} strokeWidth={2} />
              </a>
              <a href="#" className="social-link-tech">
                <Twitter size={20} strokeWidth={2} />
              </a>
            </div>
          </div>
          <div className="footer-section-tech">
            <h3 className="footer-title-tech">Навигация</h3>
            <ul className="footer-links-tech">
              <li><a href="/">Мои проекты</a></li>
              <li><a href="/enroll">Записаться</a></li>
              <li><a href="#">Курсы</a></li>
              <li><a href="#">О нас</a></li>
            </ul>
          </div>
          <div className="footer-section-tech">
            <h3 className="footer-title-tech">Контакты</h3>
            <ul className="footer-links-tech">
              <li>
                <Phone size={16} strokeWidth={2} />
                <a href="tel:+79991234567">+7 (999) 123-45-67</a>
              </li>
              <li>
                <Mail size={16} strokeWidth={2} />
                <a href="mailto:info@editpro.ru">info@editpro.ru</a>
              </li>
              <li>
                <MapPin size={16} strokeWidth={2} />
                <span>Москва, ул. Технологическая, 12</span>
              </li>
            </ul>
          </div>
          <div className="footer-section-tech">
            <h3 className="footer-title-tech">Режим работы</h3>
            <ul className="footer-links-tech">
              <li><span>Пн-Пт: 10:00 - 20:00</span></li>
              <li><span>Сб-Вс: 12:00 - 18:00</span></li>
              <li><span>Онлайн: 24/7</span></li>
            </ul>
          </div>
        </div>
        <div className="footer-bottom-tech">
          <p>&copy; 2025 EditPro. Профессиональный видеомонтаж начинается здесь.</p>
        </div>
      </div>
    </footer>
  )
}

export default Footer

